import React, { memo } from 'react';
import cx from 'classnames';

import { Icon, Button } from 'bebo-ui';

import css from './lobby-tracking.module.scss';

import { track } from 'scripts/analytics';

import titlelyfy from 'title';

const LobbyTracking = memo(({ lobbyState, ownUserState, modeName }) => {
  const { pc, mixer } = ownUserState;

  const renderMessage = lobbyState => {
    switch (lobbyState) {
      case 'pcStream':
        return (
          <TrackingMessage
            header="Turning on Score Tracking"
            text="Hang tight, this will just take a sec."
            hasHelp
            state={lobbyState}
          />
        );

      case 'aiDetect':
        //  detect fortnite  + tell to select right mode
        return (
          <TrackingMessage
            header="Detecting Game"
            text={
              <span>
                Make sure your game is open, you're in the lobby, and <strong>{modeName}</strong> is
                selected.
              </span>
            }
            hasHelp
            state={lobbyState}
          />
        );
      case 'pcNoApp':
        // tell to downlaod app
        return (
          <TrackingMessage
            header="You Need The Score Tracker!"
            text="Make sure the BEBO PC app is running."
            hasHelp
            state={lobbyState}
          />
        );
      default:
        return (
          <TrackingMessage header="You're good to go" text="Waiting for your team to ready up." />
        );
    }
  };

  const platform = pc ? 'pc' : mixer ? 'xbox' : 'none';

  return (
    <div className={css.tracking}>
      <TrackingPlatform platform={platform} state={'active'} />
      {renderMessage(lobbyState)}
    </div>
  );
});

export default LobbyTracking;

const TrackingMessage = memo(({ header, text, action, hasHelp, state }) => {
  return (
    <div className={css.message}>
      {header && <span className={css.messageHeader}>{titlelyfy(header)}</span>}
      {text && <span className={css.messageText}>{text}</span>}
      {action && <span className={css.messgeAction}>{action}</span>}
      {hasHelp && (
        <Button
          onClick={() => track('lobby', 'help', state)}
          secondary
          fluid
          link="https://discord.gg/Jf9EuSe"
          external
        >
          Need Help? Get Help.
        </Button>
      )}
    </div>
  );
});

const TrackingPlatform = memo(({ platform, state }) => {
  const iconMap = {
    pc: 'win10',
    xbox: 'xbox',
    none: 'no-platform'
  };

  return (
    <div className={cx(css.platform, css[state])}>
      {iconMap[platform] && (
        <Icon icon={iconMap[platform]} className={css.platformIcon} size={25} />
      )}
      <TrackingIndicator state="active" platform={platform} />
    </div>
  );
});

const TrackingIndicator = ({ size, state }) => {
  return (
    <svg
      className={cx(css.trackingIndicator, css[state])}
      width={size}
      height={size}
      viewBox="0 0 33 33"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="M24.6634 2.54606C19.6354 -0.696502 13.2017 -0.831002 8.06309 2.10925L9.39362 3.40736C13.7769 1.1059 19.1181 1.24451 23.3931 3.84817L24.6634 2.54606Z" />
      <path d="M27.9741 8.31741L29.2445 7.01531C32.6103 11.9619 32.9036 18.3905 30.0909 23.6003L28.7603 22.3022C30.9531 17.8633 30.6827 12.5269 27.9741 8.31741Z" />
      <path d="M8.61516 28.1599C13.5921 31.1913 20.0142 30.8816 24.6877 27.2701L25.9714 28.5226C20.5901 32.8182 13.0595 33.1476 7.34478 29.462L8.61516 28.1599Z" />
      <path d="M4.52764 7.60132C1.03264 12.3623 0.881317 18.7898 4.03429 23.6904L2.7639 24.9926C-1.06128 19.3705 -0.917586 11.8343 3.24389 6.34885L4.52764 7.60132Z" />
    </svg>
  );
};
