import React from 'react';
import { storiesOf } from '@storybook/react';
import centered from '@storybook/addon-centered';
import { withViewport } from '@storybook/addon-viewport';
import { withKnobs, select } from '@storybook/addon-knobs';
import Lobby from './index';

// props
const props = {
  lobbyState: 'readyUp',
  league: {
    url: '/league',
    owner_id: 'service',
    league_id: 'a7f71d1c-6eb4-4b28-9387-62734737c1ea',
    name: 'jakesolo6',
    description: '',
    active_division_id: '10bed5cd-7aae-4733-baa3-b9db2828a475',
    active_tournament_id: null,
    image_url: 'https://i.imgur.com/7UXgufe.png',
    // "image_url": "https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_league.png",
    // "image_url": "https://pbs.twimg.com/profile_images/1073607078109949957/74oimLX4_400x400.jpg",
    timezone: 'America/Los_Angeles',
    division_size: 120,
    team_size: 1,
    created_dttm: '2019-01-17T22:24:05.887Z',
    updated_dttm: '2019-01-22T23:59:45.590Z',
    deleted_dttm: null,
    isWaiting: false
  },
  redirectUrl: '/league/a7f71d1c-6eb4-4b28-9387-62734737c1ea/10bed5cd-7aae-4733-baa3-b9db2828a475',
  ownUserState: {
    pc: true,
    bran: false,
    mixer: false,
    ready: false,
    walle: true,
    fortwatch: false,
    walle_url:
      'rtmp://usw11531300511-walle-00008953848682.aws.bebo-dev.com/relay/b27e968c-53d3-49a6-b5c9-78d8398cbaab'
  },
  actingTeam: {
    url: '/team',
    owner_id: '19bd0c04-b00a-4646-b52d-8570e4f0088f',
    team_id: 'fc753a0e-3cd0-4b85-8360-bc0a1e66d4b2',
    league_id: 'a7f71d1c-6eb4-4b28-9387-62734737c1ea',
    active_division_id: '10bed5cd-7aae-4733-baa3-b9db2828a475',
    active_tournament_id: null,
    invite_url: null,
    name: 'rachet-blade',
    image_url: 'https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_user.png',
    created_dttm: '2019-01-23T00:04:23.010Z',
    updated_dttm: '2019-01-23T00:04:23.010Z',
    deleted_dttm: null,
    users: [
      {
        days: null,
        url: '/user',
        username: 'rachet-blade',
        user_id: 'a',
        image_url: 'https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_user.png'
      },
      {
        days: null,
        url: '/user',
        username: 'sorkzor',
        user_id: 'b',
        image_url: 'https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_user.png'
      }
    ]
  },
  canCancel: true,
  userStates: {
    a: {
      pc: true,
      bran: false,
      mixer: false,
      ready: true,
      walle: false,
      fortwatch: false,
      walle_url:
        'rtmp://usw11531300511-walle-00008953848682.aws.bebo-dev.com/relay/b27e968c-53d3-49a6-b5c9-78d8398cbaab'
    },
    b: {
      pc: true,
      bran: false,
      mixer: false,
      ready: false,
      walle: true,
      fortwatch: false,
      walle_url:
        'rtmp://usw11531300511-walle-00008953848682.aws.bebo-dev.com/relay/b27e968c-53d3-49a6-b5c9-78d8398cbaab'
    }
  }
};

const STATES = {
  platform: 'platform',
  mixerUsername: 'mixerUsername',
  mixerStream: 'mixerStream',
  pcStream: 'pcStream',
  aiDetect: 'aiDetect',
  pcNoApp: 'pcNoApp',
  readyUp: 'readyUp'
};

// Story

storiesOf('Lobby', module)
  .addDecorator(centered)
  .addDecorator(withViewport('iphone6'))
  .add('default', () => {
    const lobbyState = select('Lobby State', STATES, 'readyUp');
    return <Lobby {...props} lobbyState={lobbyState} />;
  });
