import React, { useMemo } from 'react';
import css from './match-card.module.scss';

import { Loader, TeamAvatar } from 'bebo-ui';

import { Link } from '@reach/router';

import config from 'scripts/config';

const MatchCard = ({ match, index, round, link }) => {
  const { sets, tournament_bracket } = match;

  // console.log('*** bracket', { tournament_bracket });

  const matchState = useMemo(() => {
    return match && match.state;
  }, [match]);

  if (sets && sets.length < 2) {
    return (
      <div className={css.matchCardWrapper}>
        <label>
          {round && (
            <span>
              {round && round.isFinal ? 'Final' : `Match ${index + 1}`} {'  '}-{'  '}
            </span>
          )}
          <span
            style={{
              color:
                matchState === 'ended' || matchState === 'started'
                  ? '#B08414'
                  : 'rgba(255,255,255,.7)'
            }}
          >
            {matchState}
          </span>
        </label>
        <div className={css.matchCard}>
          <div
            className={css.matchCardBar}
            style={{ background: tournament_bracket === 'upper' ? '#0578e6' : '#fd6161' }}
          />
          {sets.map((set, i) => (
            <MatchCardTeam key={`${set.set_id}_${i}`} set={set} />
          ))}
        </div>
      </div>
    );
  }

  return (
    <Link to={link} className={css.matchCardWrapper}>
      <label>
        {round && (
          <span>
            {round && round.isFinal ? 'Final' : `Match ${index + 1}`} {'  '}-{'  '}
          </span>
        )}
        <span
          style={{
            color:
              matchState === 'ended' || matchState === 'started'
                ? '#B08414'
                : 'rgba(255,255,255,.7)'
          }}
        >
          {matchState}
        </span>
      </label>
      <div className={css.matchCard}>
        <div
          className={css.matchCardBar}
          style={{ background: tournament_bracket === 'upper' ? '#0578e6' : '#fd6161' }}
        />
        {sets.map((set, i) => (
          <MatchCardTeam key={`${set.set_id}_${i}`} set={set} index={i} />
        ))}
      </div>
    </Link>
  );
};

export default MatchCard;

export const MatchCardTeam = ({ set, index }) => {
  let computedOutcomeState = null;
  if (set.outcome && set.outcome !== 'waiting') {
    computedOutcomeState = set.outcome;
  } else {
    computedOutcomeState = set.state;
  }

  const readableState = useMemo(() => {
    switch (computedOutcomeState) {
      case 'ended':
        return 'Finished';
      case 'waiting':
        return 'Not started';
      case 'started':
        return 'Playing';
      case 'win':
        return 'Winner';
      case 'loss':
        return 'Defeated';
      default:
        return computedOutcomeState;
    }
  }, [computedOutcomeState]);

  if (set._noOpponent) {
    return (
      <div className={css.matchCardTeam}>
        <div style={{ height: 36, width: 36, display: 'flex' }}>
          <Loader style={{ margin: 'auto' }} size={25} />
        </div>
        <div className={css.matchCardTeamMeta}>
          <h4>No Opponent</h4>
          <h4 className={css.waiting}>Waiting For Opponent</h4>
        </div>
        <h3>?</h3>
      </div>
    );
  }

  return (
    <div className={css.matchCardTeam}>
      <TeamAvatar
        icon={
          !config.isProd() && set._seed ? (
            <div
              style={index < 1 ? { borderColor: '#302c38' } : { borderColor: '#28252f' }}
              className={css.matchTeamSeed}
            >
              {set._seed}
            </div>
          ) : null
        }
        className={css.matchTeamAvatar}
        {...set.team}
        size={40}
      />
      <div className={css.matchCardTeamMeta}>
        <h4>
          {(set && set.team && set.team.name) ||
            (set && set.team && set.team.users && set.team.users.map(u => u.username).join(' / '))}
          <br />
          <span>
            ({set && set.team && set.team.users && set.team.users.map(u => u.username).join(' / ')})
          </span>
        </h4>
        <h4 className={css[computedOutcomeState]}>{readableState}</h4>
      </div>
      <h3>{set.scores.reduce((a, b) => a + b, 0)}</h3>
    </div>
  );
};
