import React, { memo } from 'react';
import { Link } from '@reach/router';
import cx from 'classnames';

import css from './match-item.module.scss';
import { colors } from '../../theme';

import { TeamAvatar } from 'bebo-ui';

const MatchItem = memo(({ route, match }) => {
  // const { sets, tournament_bracket } = match;

  const challenger = match.sets[1];
  const opponent = match.sets[0];

  const challengerScore = challenger.scores.reduce((a, b) => a + b);
  const opponentScore = opponent.scores.reduce((a, b) => a + b);

  // const matchState = useMemo(() => {
  //   return match && match.state;
  // }, [match && match.state]);

  // console.log('match **', match);

  const renderBody = () => {
    return (
      <>
        <Team
          team={challenger.team}
          color={colors.blueTeam}
          winner={challengerScore >= opponentScore}
          score={challengerScore}
        />
        {/* <Score/> */}
        <Team
          team={opponent.team}
          color={colors.redTeam}
          winner={challengerScore <= opponentScore}
          score={opponentScore}
          reverse
        />
      </>
    );
  };

  if (route) {
    return (
      <Link to={route} className={css.item}>
        {renderBody()}
      </Link>
    );
  }

  return <li className={css.item}>{renderBody()}</li>;
});

export default MatchItem;

// const Score ({}) => {
//   return <div className={css.score}>
//     <span className={css.scoreChallenger}></span>
//     <span className={css.scoreSeperator}/>>/sp
//   </div>
// }

const Team = memo(({ team, score, color, reverse, winner, expand }) => {
  return (
    <div className={cx(css.team, { [css.reverse]: reverse })}>
      <TeamAvatar className={css.teamAvatar} team={team} size={48} />
      <span className={css.teamName}>
        <span className={css.teamNameText}>
          {team.name} {team.name}{' '}
        </span>
        {winner && <span className={css.teamWinner} />}
      </span>
      {/* <span className={css.teamScore} style={{color}}>
      {score}
    </span> */}
    </div>
  );
});

// {
//   match.sets[0].scores: (3) [1, 14, 13]
//   challengers: [{…}]
//   created_dttm: "2019-01-03T22:16:02.998Z"
//   data: {state: {…}}
//   deleted_dttm: null
//   division_id: "c84ba21a-39d8-4f5c-ac3c-6d2845d76029"
//   match_id: "57a3e7d0-47a0-45fe-a215-f28d15bbfbb9"
//   opponent_scores: (3) [4, 0, 0]
//   opponents: [{…}]
//   outcome: "win"
//   owner_id: "03f4ebc8-03eb-41a8-b33d-b5c9fbfb6301"
//   round: 4
//   state: "ended"
//   updated_dttm: "2019-01-04T00:36:37.433Z"
//   url: "/match"
//   victory: true
// }

///// CHALLENGER

// created_dttm: "2019-01-03T22:16:03.031Z"
// deleted_dttm: null
// division_id: "c84ba21a-39d8-4f5c-ac3c-6d2845d76029"
// ended_dttm: "2019-01-04T00:36:37.425Z"
// owner_id: "03f4ebc8-03eb-41a8-b33d-b5c9fbfb6301"
// scores: [1, 14, 13]
// set_id: "0c15792d-0822-4f96-bca5-f4019720e8de"
// started_dttm: "2019-01-03T23:29:58.877Z"
// team: {url: "/team", owner_id: "03f4ebc8-03eb-41a8-b33d-b5c9fbfb6301",…}
// team_id: "69a66ed0-4612-4065-ba7f-a9817bdcf304"
// updated_dttm: "2019-01-04T00:36:37.425Z"
// url: "/set"
