import React, { memo, useMemo } from 'react';

import css from './match-list.module.scss';

// import MatchListItem from './match-list-item.js';
import { Loader } from 'bebo-ui';

import MatchCard from 'components/match-card';

const MatchList = memo(({ matches, team_id, league_id }) => {
  const renderMatches = useMemo(
    () =>
      matches.map(match => {
        let sets = [];

        const ownSetIndex = match.sets.findIndex(
          set => set && set.team && set.team.team_id === team_id
        );
        if (ownSetIndex === 1) {
          sets = [match.sets[1], match.sets[0]];
        } else if (match.sets.length === 2) {
          if (ownSetIndex === 1) {
            sets = [match.sets[1], match.sets[0]];
          } else {
            sets = [match.sets[0], match.sets[1]];
          }
        } else {
          sets = [match.sets[0], null];
        }

        for (let i = 0; i < sets.length; i++) {
          if (!sets[i]) {
            sets[i] = { set_id: 'waiting_set_' + i, _noOpponent: true };
          }
        }

        const link = `/app/league/${league_id}/match/${match && match.match_id}`;
        return { ...match, sets, link };
      }),
    [matches, team_id, league_id]
  );
  return renderMatches ? (
    renderMatches.length ? (
      <ul className={css.list}>
        {renderMatches.map(match => (
          <MatchCard link={match.link} key={match.match_id} match={match} />
        ))}
      </ul>
    ) : (
      <div className={css.list}>
        <p style={{ margin: '20px auto', textAlign: 'center' }}>No matches played yet this week</p>
      </div>
    )
  ) : (
    <Loader size={20} />
  );
});

export default MatchList;
