import React from 'react';
import { storiesOf } from '@storybook/react';
import centered from '@storybook/addon-centered';
import MatchList from './index.js';

const team = {
  image_url:
    'https://res.cloudinary.com/teepublic/image/private/s--_7KTQYHP--/t_Preview/b_rgb:ffffff,c_limit,f_jpg,h_630,q_90,w_630/v1506619089/production/designs/1936250_1.jpg',
  name: 'Cloud 9'
};

const createMatch = state => {
  return {
    challenger_scores: [1, 14, 13],
    challengers: [],
    opponent_scores: [4, 0, 0],
    opponents: [],
    match_id: Math.floor(900000 * Math.random()) + 100000,
    state
  };
};

const generateMatches = n => [...Array(n)].map((_, i) => createMatch('ended'));

storiesOf('MatchList', module)
  .addDecorator(centered)
  .add('default', () => (
    <div style={{ width: '100vw', maxWidth: '355px', height: '90vh', position: 'relative' }}>
      <MatchList matches={generateMatches(5)} />
    </div>
  ))
  .add('Large', () => (
    <div style={{ width: '100vw', maxWidth: '355px', height: '90vh', position: 'relative' }}>
      <MatchList matches={generateMatches(20)} />
    </div>
  ));
