import React, { memo } from 'react';

import css from './match-info-sheet.module.scss';
import MatchInfoImg01 from './assets/match-info-01.png';
import MatchInfoImg02 from './assets/match-info-02.png';
import MatchInfoImg03 from './assets/match-info-03.png';

const MatchInfoSheet = memo(({ modeName = 'solos' }) => {
  return (
    <div className={css.container}>
      <h2>How to play</h2>
      <section className={css.matchDetailsSection}>
        <header className={css.header}>
          <h3 className={css.title}>Play 3 games</h3>
        </header>
        <div className={css.matchDetailsItem}>
          <img src={MatchInfoImg01} alt="Play 3 games" />
          <p>
            Play public matches, queue up in <strong>{modeName}</strong> only.
            <br />
            <small>Don't wait for your opponent. You don't need to be in the same lobby.</small>
          </p>
        </div>
      </section>
      <section className={css.matchDetailsSection}>
        <header className={css.header}>
          <h3 className={css.title}>Scoring</h3>
        </header>
        <ul className={css.matchDetailsList}>
          <div className={css.matchDetailsItem}>
            <p>Earn points for every Elimination & Victory:</p>
          </div>
          <li className={css.matchDetailsItem}>
            <img src={MatchInfoImg02} alt="1 point per kill, 10 points per Victory" />
          </li>
          <li className={css.matchDetailsItem}>
            <img src={MatchInfoImg03} alt="Victor" />
            <p>The team with the highest score after all 3 games wins</p>
          </li>
        </ul>
      </section>
      <section className={css.matchDetailsSection}>
        <header className={css.header}>
          <h3 className={css.title}>Live Score Tracking</h3>
        </header>
        <div className={css.matchDetailsItem}>
          <p>
            The app will keep track of your scores automatically. If you run into a problem, contact
            us in{' '}
            <a target="_blank" rel="noopener noreferrer" href="https://discord.gg/bDYRvjb">
              Discord
            </a>
            .
          </p>
        </div>
      </section>
    </div>
  );
});

export default MatchInfoSheet;
