import React, { memo, useState, useMemo, useCallback } from 'react';

import { Avatar } from 'bebo-ui';
import VideoCard from 'components/video-card';

import css from './match-video.module.scss';

const MatchVideo = memo(({ isActiveMatch, selectedUser, userStates, sets }) => {
  const [videoEnded, setVideoEnded] = useState(false);

  const selectedUserState = useMemo(() => {
    return userStates[selectedUser && selectedUser.user_id] || null;
  }, [selectedUser, userStates]);

  const hasBran = useMemo(() => {
    return (selectedUserState && selectedUserState.bran) || false;
  }, [selectedUserState]);

  const selectedUserHLSUrl = useMemo(() => {
    return (selectedUserState && selectedUserState.walle_hls_url) || null;
  }, [selectedUserState]);

  const userSet =
    sets &&
    Array.isArray(sets) &&
    sets.find(
      set =>
        set.team &&
        set.team.users &&
        set.team.users.findIndex(
          user => ((user && user.user_id) || 1) === ((selectedUser && selectedUser.user_id) || 2)
        ) > -1
    );

  const isDisabled = useMemo(() => {
    if (!selectedUser) {
      return 'Please select a user below to watch their live video feed.';
    }
    if (!selectedUserState || !selectedUserState.walle_hls_url) {
      return 'Video is not available for this user.';
    }

    if (!userSet) {
      return 'Something went wrong, please select a different user.';
    }

    if (
      (userSet && userSet.state === 'started') ||
      (userSet && userSet.state === 'ended' && !videoEnded)
    ) {
      if (!hasBran) {
        return 'Videostream is starting up.';
      }
      return null;
    } else if (userSet && userSet.state === 'ended') {
      return 'This user finished their games. No video available.';
    } else if (
      (userSet && userSet.state === 'waiting') ||
      (userSet && userSet.state === 'created')
    ) {
      return null;
    }
    return 'Sadly no video available for this user.';
  }, [selectedUser, selectedUserState, videoEnded, hasBran, userSet]);

  const teanName = userSet && userSet.team && userSet.team.name;
  const round = userSet && userSet.round;
  const state = userSet && userSet.state;

  const onVideoEnd = useCallback(() => {
    setVideoEnded(true);
  }, []);

  return (
    <>
      <div className={css.matchVideo}>
        <div className={css.matchVideoInner}>
          {selectedUser && (
            <MatchVideoInfo
              teamName={teanName}
              selectedUser={selectedUser}
              round={round}
              state={state}
            />
          )}
          <div className={css.container}>
            {/* {isDisabled && <div className={css.matchVideoError}>{isDisabled}</div>} */}

            <VideoCard
              overlay={isDisabled}
              muted={isActiveMatch}
              url={selectedUserHLSUrl}
              onVideoEnd={onVideoEnd}
            />
          </div>
        </div>
      </div>
      <span className={css.matchVideoTip}>Switch between Streams Below</span>
    </>
  );
});

export default MatchVideo;

const MatchVideoInfo = memo(({ selectedUser, active, teamName, round, state }) => {
  return (
    <div className={css.matchVideoHeader}>
      <Avatar className={css.matchVideoHeaderAvatar} size={35} user={selectedUser} />
      <div className={css.matchVideoHeaderMeta}>
        <span className={css.matchVideoHeaderName}>
          {state === 'started' ? <span className={css.badge}>LIVE</span> : null}
          <span className={css.matchVideoHeaderNameText}>{selectedUser.username}</span>
        </span>
        <span className={css.matchVideoHeaderTeam}>
          {teamName}
          <i>
            {round === 0 ? 'is getting ready' : state === 'started' ? 'is playing' : 'finished'}
          </i>
          {state === 'started' && round ? <b>Round {round}</b> : null}
        </span>
      </div>
    </div>
  );
});

// const MatchVideoFooter = memo(({ viewsString }) => {
//   return (
//     <div className={css.matchVideoStats}>
//       <span className={css.matchVideoStatsViews}>Select a different stream below</span>
//     </div>
//   );
// });
