import React from 'react';
import { storiesOf } from '@storybook/react';
import centered from '@storybook/addon-centered';

import Match from './index.js';

const fakeUser = name => {
  return {
    user: {
      username: name,
      user_id: name + Math.random()
    },
    score: Math.floor(Math.random() * 10)
  };
};

// data
const props = {
  challenger: {
    players: [
      fakeUser('kashew'),
      fakeUser('faze')
      // fakeUser('dempz'),
      // fakeUser('nibor'),
    ],
    score: 89,
    image_url:
      'https://img0-placeit-net.s3-accelerate.amazonaws.com/uploads/stage/stage_image/16452/large_thumb_stage.jpg'
  },
  opponent: {
    players: [
      fakeUser('fitzek'),
      fakeUser('jokerf15')
      // fakeUser('villakilla'),
      // fakeUser('theDude'),
    ],
    score: 50,
    image_url: 'https://i.pinimg.com/originals/c2/7a/44/c27a44651519e95e40b9962d94756e79.jpg'
  }
};

const style = {
  width: '100vw',
  height: '100vh'
};

// Story

storiesOf('Match', module)
  .addDecorator(centered)
  .add('default', () => (
    <div style={style}>
      <Match {...props} />
    </div>
  ));
