import React, { memo, useState, useEffect } from 'react';
import posed from 'react-pose';

import { Tunnel } from 'react-tunnels';

import css from './sheet.module.scss';

export const Sheet = posed.div({
  open: {
    applyAtStart: { display: 'flex', zIndex: 100 },
    opacity: 1
  },
  closed: {
    applyAtStart: { zIndex: 99 },
    applyAtEnd: { display: 'none' },
    opacity: 0
  }
});

export const SheetInner = posed.div({
  open: {
    y: `0%`,
    transition: {
      y: { type: 'spring', stiffness: 750, damping: 50 }
    }
  },
  closed: {
    y: `100%`,
    transition: {
      y: { type: 'spring', stiffness: 750, damping: 50 }
    }
  }
});

const SheetModal = memo(({ children, onClose, noPadding, open = false }) => {
  let mounted = false;
  const [hidden, setHidden] = useState(true);
  const handlePoseComplete = pose => {
    if (!mounted) {
      return;
    }
    if (pose === 'closed') {
      setHidden(true);
    } else {
      setHidden(false);
    }
  };
  useEffect(() => {
    //eslint-disable-next-line
    mounted = true;
    return () => {
      mounted = false;
    };
  }, []);

  return (
    <Tunnel id={'modal-sheet'}>
      <Sheet
        hidden={!open && hidden}
        onPoseComplete={handlePoseComplete}
        className={css.sheet}
        pose={open ? 'open' : 'closed'}
        initialPose="closed"
      >
        <div className={css.sheetBackground} onClick={onClose} />
        <SheetInner style={noPadding && { padding: 0 }} className={css.sheetInner}>
          {!(!open && hidden) ? children : null}
        </SheetInner>
      </Sheet>
    </Tunnel>
  );
});

export default SheetModal;
