import React, { memo, useState } from 'react';

import { Column, Row, FullSizeLoader, UserLink, IconButton } from 'bebo-ui';

import useActingUser from 'hooks/useActingUser';
import useSocketSubscription from 'hooks/useSocketSubscription';

import LeagueSidebar from 'components/league-sidebar';
// import DivisionSidebar from 'components/division-sidebar';

import DownloadPrompt from 'components/download-prompt';

import { isDesktopApp } from 'scripts/utils';

import css from './off-canvas.module.scss';

import Sheet from 'components/modal-sheet';

import SettingsContainer from 'components/settings';
import PlayerSettings from 'components/settings/player-settings';

const OffCanvas = memo(() => {
  const actingUser = useActingUser();
  const [showUserModal, setShowUserModal] = useState(false);

  const [PCAppRunning] = useSocketSubscription(`/user/state/pc`, {}, null, {
    isSingleValue: true,
    reFetch: true
  });

  if (!actingUser) {
    return <FullSizeLoader />;
  }

  const leagues = actingUser.leagues || [];

  return (
    <>
      <Column style={{ height: '100%', width: '100%' }}>
        <Row className={css.container}>
          <Column>
            <LeagueSidebar large leagues={leagues || []} />
          </Column>
        </Row>
        {!isDesktopApp() && (!PCAppRunning || !PCAppRunning.exist) && (
          <Row className={css.downloadPromptContainer}>
            <DownloadPrompt inline />
          </Row>
        )}
        <Row className={css.userCard}>
          <div className={css.user}>
            <UserLink user={actingUser} size={36} onClick={() => setShowUserModal(true)} />
          </div>
          <div className={css.actions}>
            <IconButton icon="nav-settings" color="#fff" onClick={() => setShowUserModal(true)} />
          </div>
        </Row>
      </Column>
      <Sheet open={showUserModal} onClose={() => setShowUserModal(false)}>
        {/* <UserSettings onClose={() => setShowUserModal(false)} /> */}
        <SettingsContainer>
          <PlayerSettings onClose={() => setShowUserModal(false)} />
        </SettingsContainer>
      </Sheet>
    </>
  );
});

export default OffCanvas;
