import React, { memo } from 'react';
import cx from 'classnames';
import { Icon } from 'bebo-ui';

import css from './season-info.module.scss';

const DEFAULT_SEASON = { number: 0, prizes: '$1,000 Cash and Prizes ' };

const SeasonInfo = memo(({ season = DEFAULT_SEASON, isDuos = false, isT100 }) => {
  if (isT100) {
    return (
      <div className={css.container}>
        <header className={css.header}>
          <h2 className={css.title}>March Top 100 League</h2>
        </header>
        <ul className={css.calendar}>
          <CalendarItem
            title="Week 1-4"
            dateRange="March 1-30"
            icon="line-ribbon"
            description={'Play 5 matches each week'}
            selected
          />
          <CalendarItem
            title="T100 March Finale"
            dateRange="March 30, 11am PT"
            icon="line-trophy"
            description={'3 points to qualify, seeding based on points, $200 prize pool'}
            selected
          />
        </ul>
      </div>
    );
  }
  if (isDuos) {
    return (
      <div className={css.container}>
        <header className={css.header}>
          <h2 className={css.title}>March Madness</h2>
        </header>
        <ul className={css.calendar}>
          <CalendarItem
            title="Week 1-4"
            dateRange="March 1-30"
            icon="line-ribbon"
            description={'Play 5 matches each week'}
            selected
          />
          <CalendarItem
            title="T100 March Finale"
            dateRange="March 30, 5pm PT"
            icon="line-trophy"
            description={'9 points to qualify, seeding based on points, $200 prize pool'}
            selected
          />
        </ul>
      </div>
    );
  }

  return (
    <div className={css.container}>
      <header className={css.header}>
        <h2 className={css.title}>March Madness</h2>
      </header>
      <ul className={css.calendar}>
        <CalendarItem
          title="Week 1-4"
          dateRange="March 1-29"
          icon="line-ribbon"
          description={'Play 5 matches each week'}
          selected
        />
        <CalendarItem
          title="T100 March Finale"
          dateRange="March 29, 12pm PT"
          icon="line-trophy"
          description={'9 points to qualify, seeding based on points, $200 prize pool'}
          selected
        />
      </ul>
    </div>
  );
});

const CalendarItem = memo(({ title, dateRange, icon, selected, description }) => {
  return (
    <li className={cx(selected ? css.calendarItemActive : css.calendarItem)}>
      <Icon className={css.calendarItemIcon} size={30} icon={icon} />
      <div className={css.calendarItemInfo}>
        <header className={css.calendarItemHeader}>
          <span className={css.calendarItemTitle}>{title}</span>
          <span className={css.calendarItemDateRange}>{dateRange}</span>
        </header>
        <p className={css.calendarItemDescription}>{description}</p>
      </div>
    </li>
  );
});

export default SeasonInfo;
