import React, { memo, useState } from 'react';
import cx from 'classnames';
import Carousel from 'nuka-carousel';
import useMobileDetect from 'use-mobile-detect-hook';

import css from './section.module.scss';

import { IconButton } from 'bebo-ui';

const Section = memo(({ className, header, children, horizontalList, noPadding, actions }) => {
  const detectMobile = useMobileDetect();
  const listCount = React.Children.count(children);
  const [listIndex, setListIndex] = useState(0);

  const onNext = () => {
    console.log('onNext :: ', { listIndex, children, listCount });
    if (listIndex + 1 > listCount - 1) {
      return console.log('onNext :: return', listIndex);
    }
    setListIndex(listIndex + 1);
  };

  const onBack = () => {
    console.log('onBack :: ', listIndex);
    if (listIndex === 0) {
      return console.log('onBack :: return', listIndex);
    }
    setListIndex(listIndex - 1);
  };

  const onAfterSlide = index => {
    if (index === listIndex) {
      return console.log('already same list index');
    }
    return setListIndex(index);
  };

  const renderContent = () => {
    if (horizontalList) {
      return (
        <Carousel
          onNext={onNext}
          onBack={onBack}
          slideIndex={listIndex}
          withoutControls
          slideWidth={0.8}
          className={css.sectionHorizontalList}
          afterSlide={onAfterSlide}
        >
          {children}
        </Carousel>
      );
    }
    return children;
  };

  const renderActions = () => {
    const isMobile = detectMobile.isMobile();
    return (
      <ul className={css.actions}>
        {actions}
        {horizontalList && !isMobile && <HorizontalListControls onBack={onBack} onNext={onNext} />}
      </ul>
    );
  };

  return (
    <section
      className={cx(css.section, { [css.noPadding]: noPadding || horizontalList }, className)}
    >
      {header && (
        <span className={css.sectionHeader}>
          <span className={css.sectionHeaderText}>{header}</span>
          {(actions || horizontalList) && renderActions()}
        </span>
      )}
      <div className={css.sectionInner}>{renderContent()}</div>
    </section>
  );
});

export default Section;

export const SectionEmptyState = ({ image, heading, message }) => {
  return (
    <div className={css.emptyState}>
      {image && <img alt="" src={image} className={css.emptyStateImage} />}
      <span className={css.emptyStateHeading}>{heading}</span>
      <span className={css.emptyStateMessage}>{message}</span>
    </div>
  );
};

const HorizontalListControls = memo(({ onBack, onNext }) => {
  return (
    <>
      <IconButton
        className={css.horizontalListControl}
        color="#FFF"
        onClick={onBack}
        icon={'chevron-left'}
        size={25}
      />
      <IconButton
        className={css.horizontalListControl}
        color="#FFF"
        onClick={onNext}
        icon={'chevron-right'}
        size={25}
      />
    </>
  );
});
