import React, { memo, useMemo } from 'react';

import { FullSizeLoader } from 'bebo-ui';
import useSocketSubscription from 'hooks/useSocketSubscription';

import SheetTeam from './sheet-team.js';

const DivisionSummaryTeam = memo(({ actingUser, leagueId, team }) => {
  const [matchInfo] = useSocketSubscription('/match/team', { team_id: team && team.team_id }, [], {
    reFetch: true
  });

  let [matchHistory] = useSocketSubscription('/match', { team_id: team && team.team_id }, [], {
    reFetch: true,
    initOptions: { tournament_id: 'null' }
  });

  if (!team) {
    return <FullSizeLoader />;
  }

  if (!matchHistory || !matchHistory.length) {
    matchHistory = matchInfo.sort((a, b) => new Date(b.created_dttm) - new Date(a.created_dttm));
  }

  let matchesLeft = 5 - matchInfo.length;
  if (matchesLeft < 0) {
    matchesLeft = 0;
  }

  let wins = 0;
  let losses = 0;
  let draws = 0;
  for (let i = 0; i < 5; i++) {
    let record = matchInfo[i];
    if (record) {
      let ownSet = record.sets.find(
        set =>
          ((set && set.team && set.team.team_id && set.team.team_id) || 1) ===
          ((team && team.team_id) || 2)
      );
      if (ownSet.outcome === 'win') {
        wins = wins + 1;
      } else if (ownSet.outcome === 'draw') {
        draws = draws + 1;
      } else if (ownSet.outcome === 'loss') {
        losses = losses + 1;
      }
    }
  }

  const canEdit = useMemo(() => {
    if (((actingUser && actingUser.user_id) || 1) === ((team && team.owner_id) || 2)) {
      return true;
    }
    return false;
  }, [actingUser, team]);

  return (
    <SheetTeam
      matches={matchHistory}
      team={team}
      matchesLeft={matchesLeft}
      wins={wins}
      draws={draws}
      losses={losses}
      canEdit={canEdit}
      qualified={team.qualified}
    />
  );
});

export default DivisionSummaryTeam;
