import React from 'react';

import { storiesOf } from '@storybook/react';
import centered from '@storybook/addon-centered';

import SheetTeam from './sheet-team.js';

const team = {
  image_url:
    'https://res.cloudinary.com/teepublic/image/private/s--_7KTQYHP--/t_Preview/b_rgb:ffffff,c_limit,f_jpg,h_630,q_90,w_630/v1506619089/production/designs/1936250_1.jpg',
  name: 'Cloud 9'
};

const createMatch = state => {
  return {
    challenger_scores: [1, 14, 13],
    challengers: [],
    opponent_scores: [4, 0, 0],
    opponents: [],
    match_id: Math.floor(900000 * Math.random()) + 100000,
    state
  };
};

const generateMatches = n => [...Array(n)].map((_, i) => createMatch('ended'));

// data
const props = {
  team: {
    name: 'cloud 9',
    image_url: 'https://i.pinimg.com/originals/ae/ec/77/aeec77e51df667f92b899c2232b94bcb.jpg',
    owner_id: 1,
    users: [
      {
        username: 'Rajz0r',
        image_url: 'https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_user.png',
        id: 1
      },
      {
        username: 'ShonkyDonky',
        image_url: 'https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_user.png',
        id: 2
      }
    ]
  },
  stats: {},
  matches: generateMatches(10),
  matchesLeft: 4
};

// Story

storiesOf('SheetTeam', module)
  .addDecorator(centered)
  .add('default', () => (
    <div style={{ width: 355 }}>
      <SheetTeam {...props} />
    </div>
  ));
