import React, { memo } from 'react';
// import { Link } from '@reach/router';
import cx from 'classnames';

import { Button } from 'bebo-ui';

import useStorage from 'hooks/useStorage';
import useActingUser from 'hooks/useActingUser';
import useTrack from 'hooks/useTrack';

const SignupButton = memo(({ onClick, className, from, children, ...rest }) => {
  const actingUser = useActingUser();
  const [wasLoggedIn] = useStorage('wasLoggedIn', false);
  const track = useTrack('signup_btn', actingUser ? 'open' : wasLoggedIn ? 'login' : 'signup', {
    from
  });
  const signupFunnelTrack = useTrack('signup_funnel', 'signup_btn', { from });

  const handleClick = e => {
    track('click');
    signupFunnelTrack('click');
    if (onClick) {
      onClick(e);
    }
  };

  return (
    <Button
      {...rest}
      link={wasLoggedIn ? '/login' : '/signup'}
      className={cx('button', className)}
      onClick={handleClick}
    >
      {children ? children : actingUser ? 'Play Now' : wasLoggedIn ? 'Login' : 'Join the League'}
    </Button>
  );
});

export default SignupButton;
