import React, { memo, useState } from 'react';
import { format } from 'date-fns';

import css from './team.module.scss';

import { TeamAvatar, Button } from 'bebo-ui';

import Sheet from 'components/modal-sheet';
import EditTeam from 'components/settings/edit-team';
import Section, { SectionEmptyState } from 'components/section';
// import MatchItem from 'components/match-item';
import MatchCard from 'components/match-card';
// import TournamentItem from 'components/tournament-item';

import TeamMemberItem from './team-member-item';
import TeamStats from './team-stats';

const Team = memo(
  ({ team = {}, isOwner, league_id, actingTeam, matchHistory, matchInfo, standings }) => {
    const [editMode, setEditMode] = useState(false);

    // const _faketournament = [{ name: 'Mid-season Tournament' }, { name: 'Season Grand Final' }];

    // const tournaments = _faketournament.map(tournament => <TournamentItem tournament={tournament}/>)

    const teamStanding =
      standings && standings.length
        ? standings.find(standing => standing.team.team_id === team.team_id)
        : null;

    const teamRank = standings
      ? standings.findIndex(standing => standing.team.team_id === team.team_id) + 1
      : null;

    /// Sections

    const members =
      team && team.users && team.users.length
        ? team.users.map(user => <TeamMemberItem key={user.user_id} user={user} />)
        : null; // <SectionLoading/>

    const history =
      matchHistory && matchHistory.length ? (
        matchHistory.map(match => (
          <MatchCard
            key={match.match_id}
            link={`/app/league/${league_id}/match/${match.match_id}`}
            match={match}
          />
        ))
      ) : (
        <SectionEmptyState heading="No Matches Played" message="" />
      );

    const stats = <TeamStats standings={teamStanding} />;

    ///

    return (
      <>
        <Header
          isOwner={isOwner}
          team={team}
          stats={teamStanding}
          rank={teamRank}
          setEditMode={setEditMode}
        />
        {/* <Section header='Tournaments' horizontalList>
        {tournaments}
      </Section> */}
        <Section header="Members">{members}</Section>
        <Section header="Season Stats">{stats}</Section>
        <Section header="Match History">{history}</Section>
        {isOwner && (
          <Sheet open={editMode} onClose={() => setEditMode(false)}>
            <EditTeam team={team} leagueId={league_id} onUpdate={() => setEditMode(false)} />
          </Sheet>
        )}
      </>
    );
  }
);

export default Team;

const Header = memo(({ team, stats, rank, isOwner, setEditMode }) => {
  const rankColorMap = {
    1: '#D5A322',
    2: '#EFE8F7',
    3: '#EA932D'
  };

  const currentMonth = format(new Date(), 'MMMM');
  // const teamIsPlaying = true;

  return (
    <header className={css.header}>
      <div className={css.teamInfo}>
        <TeamAvatar image_url={team.image_url} className={css.avatar} size={90} />
        <div className={css.teamMeta}>
          <span className={css.teamName}> {team.name} </span>
        </div>
        {isOwner && (
          <Button onClick={() => setEditMode(true)} className={css.teamEdit}>
            Edit Team
          </Button>
        )}
      </div>
      <div className={css.season}>
        <span className={css.seasonInner}>{`${currentMonth} Season`}</span>
      </div>
      <ul className={css.teamStats}>
        <HeaderStatItem
          label={'Rank'}
          value={!rank ? '--' : `#${rank}`}
          color={rank <= 3 ? rankColorMap[rank] : null}
        />
        <HeaderStatItem label={'Points'} value={!stats ? '--' : stats.points} />
      </ul>
    </header>
  );
});

const HeaderStatItem = ({ label, value, color }) => {
  return (
    <li className={css.teamStatItem}>
      <span className={css.teamStatItemValue} style={color ? { color } : null}>
        {value}
      </span>
      <label className={css.teamStatItemLabel}>{label}</label>
    </li>
  );
};
