import React, { memo } from 'react';
import { Avatar } from 'bebo-ui';
import Linkify from 'react-linkify';

import css from './team-member-item.module.scss';

const TeamMember = memo(({ user }) => {
  return (
    <li className={css.teamMember}>
      <Avatar className={css.teamMemberAvatar} user={user} size={44} />
      <div className={css.teamMemberMeta}>
        <span className={css.teamMemberName}>{user.username}</span>
        <span className={css.teamMemberBio}>
          <Linkify properties={{ target: '_blank' }}>
            {user && user.bio ? user.bio : "I haven't filled out my profile yet"}
          </Linkify>
        </span>
      </div>
    </li>
  );
});

export default TeamMember;
