import React, { memo } from 'react';
import cx from 'classnames';
import css from './team-stats.module.scss';

const TeamStats = memo(({ standings }) => {
  const matchesPlayed = standings ? standings.win + standings.draw + standings.loss : null;
  const winRate = matchesPlayed
    ? parseInt((standings.win / matchesPlayed) * 100 * 100, 10) / 100 + '%'
    : null;

  return (
    <ul className={css.stats}>
      <TeamStatItem wide label="Wins" value={standings && standings.win} />
      <TeamStatItem wide label="Draws" value={standings && standings.draw} />
      <TeamStatItem wide label="Losses" value={standings && standings.loss} />
      <TeamStatItem wide label="Matches played" value={matchesPlayed} />
      <TeamStatItem wide label="Win rate" value={winRate} />
    </ul>
  );
});

const TeamStatItem = memo(({ label, value, wide }) => {
  return (
    <li className={cx(css.statItem, { [css.wide]: wide })}>
      <div className={css.statItemInner}>
        <label className={css.statItemLabel}>{label}</label>
        <span className={css.statItemValue}>{value ? value : '--'}</span>
      </div>
    </li>
  );
});

export default TeamStats;
