import React from 'react';
import { storiesOf } from '@storybook/react';
import { withViewport } from '@storybook/addon-viewport';
import centered from '@storybook/addon-centered';

import Team from './index.js';

/// Util

const createMatch = state => {
  return {
    challenger_scores: [1, 14, 13],
    challengers: [],
    opponent_scores: [4, 0, 0],
    opponents: [],
    match_id: Math.floor(900000 * Math.random()) + 100000,
    state,
    sets: []
  };
};

const generateMatches = n => [...Array(n)].map((_, i) => createMatch('ended'));

// data
const team_data = {
  url: '/team',
  owner_id: '19bd0c04-b00a-4646-b52d-8570e4f0088f',
  team_id: 'c435cc35-defa-43c0-9a9b-f7b7f6a92305',
  league_id: '1accdf6b-3dfb-40a9-b860-855e56210f11',
  active_division_id: 'c84ba21a-39d8-4f5c-ac3c-6d2845d76029',
  active_tournament_id: null,
  invite_url: null,
  name: 'rachet-blade',
  image_url: 'https://a.imgdropt-dev.com/image/e7bd2c3e-ad53-4036-8485-bb4a1a813cb2',
  created_dttm: '2019-02-08T00:17:46.730Z',
  updated_dttm: '2019-02-08T00:18:47.792Z',
  deleted_dttm: null,
  users: [
    {
      days: null,
      url: '/user',
      username: 'rachet-blade',
      user_id: '19bd0c04-b00a-4646-b52d-8570e4f0088f',
      image_url: 'https://a.imgdropt-dev.com/image/0276d951-c8cc-4326-aea7-d2e4f34992d0'
    },
    {
      days: null,
      url: '/user',
      bio: 'Super long bio about nothing sepcial. I am 15 and I like fortnite and I love faze',
      username: 'rachet-bladeZ',
      user_id: '19bd0c04-b00a-4646-b52d-8570e4f0x088f',
      image_url: 'https://a.imgdropt-dev.com/image/0276d951-c8cc-4326-aea7-d2e4f34992d0'
    }
  ],
  qualified: false,
  wins: 0
};

const match_hisotry = generateMatches(15);

// Story

storiesOf('Team', module)
  .addDecorator(centered)
  .addDecorator(withViewport('iphone6'))
  .add('Default', () => (
    <div style={{ width: '100%', height: '100%', position: 'absolute', top: 0, left: 0 }}>
      <Team team={team_data} matchHistory={match_hisotry} />
    </div>
  ));
