import React, { memo } from 'react';

import cx from 'classnames';
import config from 'scripts/config';

import { IconButton } from 'bebo-ui';

import LogoLink from './logo-link.js';
import './titlebar.scss';

const TitleBar = memo(({ isSignup }) => {
  const classes = cx('app-titlebar', { 'is-transparent': isSignup });
  return (
    <div className={classes}>
      <div className="app-titlebar__left">{!isSignup && <Logo env={config.env} />}</div>
      <div className="app-titlebar__center" />
      <div className="app-titlebar__right">
        <Controls />
      </div>
    </div>
  );
});

const Logo = memo(({ onClick, env }) => (
  <div className="app-navbar__logo" onClick={onClick}>
    <LogoLink
      height={19}
      width={40}
      color={env === 'ptr' ? '#16ff8c' : env === 'prod' ? 'rgb(253, 200, 35)' : '#9f3232'}
    />
  </div>
));

const Controls = memo(() => (
  <div className="app-titlebar__controls">
    <IconButton
      onClick={() => window.dispatchEvent(new Event('app.minimize'))}
      className="app-titlebar--icon"
      icon="system-minimize"
      color="#A0A0A0"
    />
    <IconButton
      onClick={() => window.dispatchEvent(new Event('app.close'))}
      className="app-titlebar--icon"
      icon="system-close"
      color="#A0A0A0"
    />
  </div>
));

export default TitleBar;
