import React, { memo } from 'react';
import cx from 'classnames';

import css from './tournament-item.module.scss';

const TournamentItem = memo(({ tournament, wins }) => {
  const { name } = tournament;

  const renderContent = () => {
    return (
      <>
        <div className={css.content}>{name}</div>
        <ProgressBar current={4} goal={10} />
      </>
    );
  };

  return (
    <li className={cx(css.tournamentItem)}>
      <div className={css.tournamentItemInner}>{renderContent()}</div>
    </li>
  );
});

export default TournamentItem;

const ProgressBar = ({ current, goal }) => {
  const renderSteps = () => {
    return [...Array(goal)].map((_, i) => (
      <li key={i} className={cx(css.progressbarStep, { [css.filled]: current > i })} />
    ));
  };

  return (
    <div className={css.progressbar}>
      <ul className={css.progressbarSteps}>{renderSteps()}</ul>
      <div className={css.progressbarValue}>
        <span className={css.progressbarCurrent}>{current}</span>
        <b>/</b>
        <span className={css.progressbarGoal}>{goal}</span>
      </div>
    </div>
  );
};
