import React from 'react';

import { Link } from '@reach/router';

import { Row, Column } from 'bebo-ui';

import { format } from 'date-fns';

import css from './tournament-list-item.module.scss';

function TournamentListItem({ tournament }) {
  return (
    <Link
      className={css.container}
      to={`./${tournament.tournament_id}`}
      key={tournament.tournament_id}
    >
      <img src={tournament.image_url} alt={tournament.name} />
      <Row className={css.detailWrapper}>
        <Column>
          <h2>{tournament.name}</h2>
          <p>{format(tournament.start_dttm, 'MMM do, p')}</p>
        </Column>
        <Column className={css.statusWrapper}>
          <p className={css[tournament.state]}>{tournament.state}</p>
        </Column>
      </Row>
    </Link>
  );
}

export default TournamentListItem;
