import React from 'react';
import { storiesOf } from '@storybook/react';
import centered from '@storybook/addon-centered';
import { withViewport } from '@storybook/addon-viewport';

import Tournament from './index.js';

const league = {
  image_url: 'https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_tournament.png'
};

const data = {
  url: '/tournament',
  owner_id: 'service',
  tournament_id: '7862f904-1666-46a4-8cef-363163f8711c',
  league_id: '614a4e27-8ed6-4a4b-aa12-4f99fcdd08eb',
  start_dttm: '2019-02-06T22:23:42.000Z',
  end_dttm: null,
  image_url: 'https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_tournament.png',
  name: 'testing testing',
  description:
    'fhj adhjfh adhsjf hjdsfhj hjasdfhj sdhj sahdfh asdhf hjsadjf skajdfjk sadhjfj asdjfkasjhdfhj as;dfjasdfjkaasdkjfjkhasdfj sadfs  aakdsfl kjasdfjkasd',
  state: 'started',
  round: '1',
  round_cnt: '5',
  wins_needed: '0',
  created_dttm: '2019-02-06T22:29:34.594Z',
  updated_dttm: '2019-02-06T22:29:38.771Z',
  deleted_dttm: null,
  prize: 'sdadkasjh hkjadhjkdhsj kadsjhj khajkdsjksaj djhk ajksdjkasdasja sjas'
};

const actingTeam = {
  wins: 3,
  qualified: true
};

// Story

storiesOf('Tournament ', module)
  // .addDecorator(centered)
  .addDecorator(withViewport('iphone6'))
  .add('Qualified', () => <Tournament actingTeam={actingTeam} tournament={data} league={league} />)
  .add('Not Qualified', () => (
    <Tournament
      actingTeam={{ ...actingTeam, qualified: false }}
      league={league}
      tournament={data}
    />
  ));
