import React, { memo } from 'react';

import cx from 'classnames';

import css from './card.module.scss';

import MatchCard from './cards/match';
import AdvancedCard from './cards/advanced';
import WinnerCard from './cards/winner';
import EliminatedCard from './cards/eliminated';

const Card = ({ cardType, ...rest }) => {
  switch (cardType) {
    case 'next_match':
      return <MatchCard {...rest} className={css.scrollCard} />;
    case 'tournament_winner':
      return <WinnerCard {...rest} className={cx(css.scrollCard, css.scrollCardRoundAdvanced)} />;
    case 'round_eliminated':
      return (
        <EliminatedCard {...rest} className={cx(css.scrollCard, css.scrollCardRoundEliminated)} />
      );
    case 'lower_bracket':
      //this needs to be the same card but about lower bracket
      return (
        <EliminatedCard
          {...rest}
          isLowerBracket
          className={cx(css.scrollCard, css.scrollCardRoundEliminated)}
        />
      );
    case 'draw':
      return (
        <AdvancedCard
          {...rest}
          isDraw
          className={cx(css.scrollCard, css.scrollCardRoundAdvanced)}
        />
      );
    case 'round_advanced':
      return <AdvancedCard {...rest} className={cx(css.scrollCard, css.scrollCardRoundAdvanced)} />;
    default:
      return null;
  }
};

export default memo(Card);
