import React, { memo } from 'react';

import css from '../card.module.scss';

import { Row } from 'bebo-ui';

const AdvancedCard = memo(({ className, actingTeam, selectedRound, isDraw }) => {
  return (
    <div className={className}>
      <div className={css.scrollCardActions}>
        <Row className={css.roundAdvancedTeam}>
          <img src={actingTeam.image_url} alt="" />
          <h4>
            {actingTeam.name ||
              (actingTeam.users && actingTeam.users.map(u => u.username).join(' / '))}
          </h4>
          <label>{isDraw ? 'Draw' : 'Advanced'}</label>
        </Row>
        <p className={css.scrollCardInfo}>
          {isDraw ? (
            <span>
              You tied! Please wait until <b>Round {selectedRound + 1}</b> starts to reveal if you
              advance to the next round.
            </span>
          ) : (
            <span>
              <b>Round {selectedRound + 1}</b> will start as soon as all the matches are finished in
              the current round.{' '}
            </span>
          )}
        </p>
      </div>
    </div>
  );
});

export default AdvancedCard;
