import React, { memo } from 'react';

import css from '../card.module.scss';

import { Row } from 'bebo-ui';

const EliminatedCard = memo(
  ({ className, actingTeam, isLowerBracket, selectedRound, singleElim }) => {
    return (
      <div className={className}>
        <div className={css.scrollCardActions}>
          <Row className={css.roundAdvancedTeam}>
            <img src={actingTeam.image_url} alt="" />
            <h4>
              {actingTeam.name ||
                (actingTeam.users && actingTeam.users.map(u => u.username).join(' / '))}
            </h4>
            <label>{isLowerBracket && !singleElim ? 'Lower Bracket' : 'Eliminated'}</label>
          </Row>

          <p className={css.scrollCardInfo}>
            {isLowerBracket && !singleElim ? (
              <span>
                You lost this round, but you still have a second chance in the lower bracket.{' '}
                <b>Round {selectedRound + 1}</b> will start as soon as all the matches in the
                current round are finished.
              </span>
            ) : (
              <span>
                Sadly you have been eliminated.
                <br />
                <b>Better luck next time!</b>
              </span>
            )}
          </p>
        </div>
      </div>
    );
  }
);

export default EliminatedCard;
