import React, { memo, useMemo } from 'react';

import css from './match.module.scss';

import { Button } from 'bebo-ui';

const MatchCard = memo(
  ({ ownNextTournamentMatch, className, ownSet, actingUser, league, ownMatch }) => {
    if (!ownNextTournamentMatch) {
      return null;
    }

    const match_id = useMemo(() => {
      return (actingUser && actingUser.active_match_id) || (ownSet && ownSet._match_id) || null;
    }, [actingUser, ownSet]);

    const matchUrl = useMemo(() => {
      if (league && league.league_id && match_id) {
        return `/app/league/${league.league_id}/match/${match_id}`;
      }
      return null;
    }, [league, match_id]);

    return (
      <div className={className}>
        <div className={css.scrollCardMatchup}>
          <div className={css.scrollCardTeam}>
            <img
              src={
                ownNextTournamentMatch.sets[0] &&
                ownNextTournamentMatch.sets[0].team &&
                ownNextTournamentMatch.sets[0].team.image_url
              }
              alt=""
            />
            <h2>
              {(ownNextTournamentMatch.sets[0] &&
                ownNextTournamentMatch.sets[0].team &&
                ownNextTournamentMatch.sets[0].team.name) ||
                (ownNextTournamentMatch.sets[0].team.users &&
                  ownNextTournamentMatch.sets[0].team.users.map(u => u.username).join(' / '))}
            </h2>
          </div>
          <div className={css.scrollCardVs}>
            <span />
            <div>
              <span>vs</span>
            </div>
            <span />
          </div>
          <div className={css.scrollCardTeam}>
            <img
              src={
                ownNextTournamentMatch.sets[1] &&
                ownNextTournamentMatch.sets[1].team &&
                ownNextTournamentMatch.sets[1].team.image_url
              }
              alt=""
            />
            <h2>
              {(ownNextTournamentMatch.sets[1] &&
                ownNextTournamentMatch.sets[1].team &&
                ownNextTournamentMatch.sets[1].team.name) ||
                (ownNextTournamentMatch.sets[1].team.users &&
                  ownNextTournamentMatch.sets[1].team.users.map(u => u.username).join(' / '))}
            </h2>
          </div>
        </div>
        <div className={css.scrollCardActions}>
          <Button
            style={{
              opacity: !ownSet || !ownSet.state || ownSet.state === 'ended' ? 0.75 : 1
            }}
            className={css.scrollCardCTA}
            primary
            inverse
            fluid
            color="#fff"
            link={matchUrl}
            disabled={!matchUrl}
          >
            {!ownSet || !ownSet.state || ownSet.state === 'ended'
              ? 'Waiting for Opponent...'
              : 'Enter Your Match'}
          </Button>
          <p className={css.scrollCardInfo}>
            {ownSet && ownSet.state === 'waiting' ? (
              <span>
                If you don't start your match within <b>10 minutes</b> you'll automatically forfeit
                this round.
              </span>
            ) : (
              <span>Your opponent has not finished their match yet.</span>
            )}
          </p>
        </div>
      </div>
    );
  }
);

export default MatchCard;
