import React, { memo } from 'react';

import css from '../card.module.scss';

import { Row } from 'bebo-ui';

const WinnerCard = memo(({ className, actingTeam }) => {
  return (
    <div className={className}>
      <div className={css.scrollCardActions}>
        <Row className={css.roundAdvancedTeam}>
          <img src={actingTeam.image_url} alt="" />
          <h4>
            {actingTeam.name ||
              (actingTeam.users && actingTeam.users.map(u => u.username).join(' / '))}
          </h4>
          <label>{'Winner'}</label>
        </Row>
        <p className={css.scrollCardInfo}>
          <span>
            <b>Congratulations you won!</b>
            <br />
            Go celebrate, tell your friends.
          </span>
        </p>
      </div>
    </div>
  );
});

export default WinnerCard;
