import React, { memo } from 'react';

import css from './team-card.module.scss';

const TeamCard = memo(({ team }) => {
  return (
    <div className={css.teamCard}>
      <h2>{team.seed}</h2>
      <img src={team.image_url} alt="" />
      <div className={css.teamCardMeta}>
        <h4>{team.name || ' '}</h4>
      </div>
      <h3>{team.score || 0}</h3>
    </div>
  );
});

export default TeamCard;
