import React, { memo } from 'react';
// import useMobileDetect from 'use-mobile-detect-hook';

// import { Icon } from 'bebo-ui';
import HLSVideo from 'components/hls-video';

import css from './video-card.module.scss';

const VideoCard = memo(({ url, muted, overlay, error, onVideoEnd }) => {
  return (
    <div className={css.videoCard}>
      {overlay && <Overlay>{overlay}</Overlay>}
      {url && (
        <HLSVideo
          muted={muted}
          autoPlay
          controls
          url={url}
          playsInline
          onEnd={onVideoEnd}
          onError={onVideoEnd}
        />
      )}
    </div>
  );
});

export default VideoCard;

const Overlay = memo(({ children }) => {
  return (
    <div className={css.overlay}>
      <span className={css.overlayText}>{children}</span>
    </div>
  );
});

// const ToggleSound = memo(({}) => {
//   return (
//     <div className={css.toggleSound}>
//       <Icon className={css.toggleSoundIcon} icon="close" size={20} />
//       <span className={css.toggleSoundText}>Tap for sound</span>
//     </div>
//   );
// });
