import React, { memo } from 'react';
// import PropTypes from 'prop-types'
import posed from 'react-pose';
import { animated as a } from 'react-spring';

import css from './view-header.module.scss';

// also run shorthand logic here in le future

const Viewheader = memo(function Viewheader({ children, st }) {
  const interpScale = st.interpolate({
    map: o => 18 - o * 1,
    range: [0, 18],
    output: ['scale(0)', 'scale(1)'],
    extrapolate: 'clamp'
  });

  const interpOpacity = st.interpolate({
    map: o => 18 - o * 1,
    range: [0, 18],
    output: [0, 1],
    extrapolate: 'clamp'
  });

  const Header = posed.div({
    enter: { opacity: 0 },
    exit: { opacity: 0 }
  });

  console.log('header:', { interpScale, st });

  return (
    <Header className={css.header}>
      <a.div className={css.inner} style={{ opacity: interpOpacity, transform: interpScale }}>
        {children}
      </a.div>
    </Header>
  );
});

Viewheader.propTypes = {};

export default Viewheader;
