import React, { memo, useState } from 'react';
import PropTypes from 'prop-types';
import css from './view.module.scss';

import ViewFooter from './view-footer';

import { animated, useSpring } from 'react-spring';

// also run shorthand logic here in le future

const View = memo(function View({ children, footer, nav, onScroll }) {
  const [isAutoScroll, setIsAutoScroll] = useState(false);
  const [{ animatedScrollTop }, set, stop] = useSpring(() => ({
    animatedScrollTop: 0,
    immediate: true,
    onRest: () => {
      setIsAutoScroll(false);
    }
  }));

  const scrollToTop = () => {
    setIsAutoScroll(true);

    set({ animatedScrollTop: 0, immediate: false });
  };

  const _onScroll = e => {
    if (!isAutoScroll) {
      set({ animatedScrollTop: e.currentTarget.scrollTop, immediate: true });
    }

    if (onScroll) {
      onScroll(e);
    }
  };

  return (
    <div className={css.view}>
      {nav && React.cloneElement(nav, { scrollToTop })}
      <div className={css.inner}>
        <animated.div
          className={css.scrollContainer}
          onScroll={_onScroll}
          scrollTop={animatedScrollTop}
          onWheel={() => {
            stop();
            setIsAutoScroll(false);
          }}
        >
          {children}
        </animated.div>
      </div>
      {footer && <ViewFooter key={'footer'}>{footer}</ViewFooter>}
    </div>
  );
});

View.propTypes = {
  nav: PropTypes.node.isRequired,
  children: PropTypes.node.isRequired,
  footer: PropTypes.node,
  onScroll: PropTypes.func
};

export default View;
