import React, { Children } from 'react';

import { storiesOf } from '@storybook/react';
import centered from '@storybook/addon-centered';

import Navbar from 'components/nav-bar';
import View from './index.js';

console.log('view', View);
// data
const props = {
  season: {
    number: 0,
    prizes: '$1,000 Cash and Prizes'
  }
};

const navProps = {
  title: 'test',
  description: 'Test',
  leftIcon: 'menu',
  rightIcon: 'star'
};

// Story

const style = {
  width: '90%',
  background: '#2C2838',
  margin: 'auto',
  marginBottom: 50,
  height: 150
};

const match = (
  <div style={{ width: '100%' }}>
    {[...Array(10)].map((_, i) => (
      <div style={style} />
    ))}
  </div>
);

const matchHeader = (
  <div
    style={{
      width: '100%',
      height: 200,
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center'
    }}
  >
    <span style={{ color: '#FFF', fontSize: 32, fontStyle: 'italic', fontWeight: 900 }}>
      VICTORY
    </span>
  </div>
);

storiesOf('View', module)
  .addDecorator(centered)
  .add('default', () => <View nav={<Navbar {...navProps} />} />);
