import config from 'scripts/config';
import { sessionStorage } from 'scripts/utils';

const _getAccessToken = () => {
  return Promise.resolve(sessionStorage.get('at'));
};

class FileController {
  static getSignedURL = (name_space, mime_type) => {
    return _getAccessToken().then(access_token => {
      const headers = {
        'Content-Type': 'application/json',
        // 'X-Riano-User-Agent': navigator.userAgent,
        'X-Access-Token': access_token
      };
      const options = {
        method: 'POST',
        headers,
        body: JSON.stringify({ name_space, mime_type })
      };

      const url = config.PICASSO_URL + '/sign';

      return fetch(url, options).then(response => response.json());
    });
  };
  static upload = (file, name_space) => {
    return FileController.getSignedURL(name_space, file.type)
      .then(sign_response => {
        if (sign_response && sign_response.result && sign_response.result[0]) {
          return sign_response.result[0];
        }
        return Promise.reject('no signed url returned');
      })
      .then(({ url, image_id }) => {
        const options = {
          method: 'PUT',
          body: file
        };

        return fetch(url, options).then(() => {
          return `${config.PICASSO_URL}/image/${image_id}`;
        });
      });
  };
}

export default FileController;
