import { POST, DELETE } from 'classes/socket';

class MatchController {
  static request = (league_id, team_id) => {
    return POST('/match', { league_id, team_id });
  };

  static cancel = match_id => {
    return POST('/match/cancel', { match_id });
  };

  static forfeit = match_id => {
    return POST('/match/forfeit', { match_id });
  };

  //TODO Move this to user controller
  static readyUp = (user_id, match_id) => {
    console.info('readyUp', user_id, match_id);
    return POST('/user/state/ready', { data: { user_id, match_id }, expire: 600 });
  };

  static unReadyUp = (user_id, match_id) => {
    console.info('readyUp', user_id, match_id);
    return DELETE('/user/state/ready', { data: { user_id, match_id } });
  };
}

export default MatchController;
