import { loggedInUser$ } from 'controllers/user';
import useObservable from './useObservable';
import useEntity from './useEntity';

const useActingUser = () => {
  const loggedInUser = useObservable(loggedInUser$);

  const actingUser = useEntity('user', loggedInUser && loggedInUser.user_id);

  if (!loggedInUser) {
    return null;
  }
  return Object.assign({}, loggedInUser, actingUser);
};

export default useActingUser;
