import { useEffect, useState, useMemo } from 'react';

import { getEntity } from 'subjects/entity-store';

import invariant from 'invariant';

const useEntities = (type, ids) => {
  invariant(typeof type === 'string', 'useEntities first paramter must be a string');
  invariant(Array.isArray(ids), 'useEntities second parameter must be an array');

  const initial = useMemo(() => {
    const i = {};
    ids.forEach(id => {
      let entity = getEntity(type, id);
      let entityValue = entity.getValue();
      if (entityValue.isWaiting) {
        return;
      }
      i[id] = entityValue;
    });
    return i;
    //eslint-disable-next-line
  }, [ids.join()]);

  const [entityObject, setEntityObject] = useState(initial);

  useEffect(() => {
    let subs = [];
    ids.forEach(id => {
      let entity = getEntity(type, id);
      let sub = entity.subscribe(entityValue => {
        if (entityValue.isWaiting) {
          return;
        }
        setEntityObject(prev => ({ ...prev, [id]: entityValue }));
      });
      subs.push(sub);
    });
    return () => {
      subs.forEach(sub => sub.unsubscribe());
      setEntityObject(() => ({}));
    };
    //eslint-disable-next-line
  }, [type, ids.join()]);

  return useMemo(() => {
    return ids.map(id => entityObject[id] || null).filter(o => o);
    //eslint-disable-next-line
  }, [ids.join(), entityObject]);
};

const useEntity = (type, ids) => {
  const idsArray = useMemo(() => {
    let _ids = ids;
    if (!_ids) {
      return [];
    }
    if (typeof _ids === 'string') {
      _ids = [ids];
    }
    return _ids;
  }, [ids]);

  const entityValues = useEntities(type, idsArray);

  return useMemo(
    () => (typeof ids === 'string' ? entityValues[0] : entityValues),
    //eslint-disable-next-line
    [entityValues]
  );
};

export default useEntity;
