import { useEffect } from 'react';
import debounce from 'lodash.debounce';

import { track } from 'scripts/analytics';

let firstLoad = true;

const useLoadTimes = () => {
  return useEffect(() => {
    if (!firstLoad) {
      return;
    }

    const { pathname } = window.location;
    try {
      window.__timeStamp('route', { pathname });
    } catch (err) {
      console.error('failed to __timeStamp route time', err);
    }
    firstLoad = false;
    let doTrack = debounce(() => {
      try {
        let timestamps = window.__times;
        const firstTime = timestamps[0].ts;
        timestamps = timestamps.map(t => ({ ...t, ts: t.ts - firstTime }));

        console.log('***', { timestamps, firstTime });
        timestamps.forEach(ts => {
          track('time', 'load', ts.label, { ...ts.data, time_nr: ts.ts });
        });
      } catch (err) {
        console.error('failed to track timestamps', err);
      }
    }, 3000);
    doTrack();
  }, []);
};

export default useLoadTimes;
