import { take } from 'rxjs/operators';
import { useState, useEffect } from 'react';

const useObservable = (observable$, initialValue = null, pipe) => {
  let initial = null;
  observable$.pipe(take(1)).subscribe(val => {
    initial = val;
  });

  const [value, update] = useState(initial || initialValue);

  useEffect(() => {
    const s = pipe ? pipe(observable$).subscribe(update) : observable$.subscribe(update);
    return () => s.unsubscribe();
    //eslint-disable-next-line
  }, [observable$]);

  return value;
};

export default useObservable;
