import { useContext } from 'react';

import { SnackbarContext } from 'components/snackbar';

import { hasErrorShape, transformErrorShape } from 'scripts/utils';

const useSnack = () => {
  const { onError, onSuccess } = useContext(SnackbarContext);
  const error = params => {
    if (hasErrorShape(params)) {
      params = transformErrorShape(params);
    }
    return onError({ ...params, text: params.message });
  };

  return { onError: error, onSuccess };
};

export default useSnack;
