import { useState, useEffect } from 'react';
import { storage } from 'scripts/utils';
import invariant from 'invariant';

const useStorage = (storage_id, init_value = null, storageAdapter = storage) => {
  invariant(storage_id, 'useStorage expects a "storage_id" to be passed as the first parameter');
  const [value, setValue] = useState(storageAdapter.get(storage_id));

  useEffect(() => {
    setValue(storageAdapter.get(storage_id));
  }, [storageAdapter, storage_id]);

  const storeAndSetValue = value => {
    storageAdapter.set(storage_id, value);
    setValue(value);
  };
  return [value, storeAndSetValue];
};

export default useStorage;
