import { useEffect, useState } from 'react';

import { subscribe } from 'classes/socket';
import { getRoutingKey } from 'scripts/utils';

const SUB_MAP = new Set();

const useSubscribeTo = (url, payload = {}) => {
  const [error, setError] = useState(null);

  let routingKey = getRoutingKey(url, payload, true);

  useEffect(() => {
    if (SUB_MAP.has(routingKey)) {
      //we're already subscribed to this, don't subscribe again
      // console.warn('trying to subscribe to a routing key we are already subscribed to', routingKey);
      return;
    }
    SUB_MAP.add(routingKey);

    subscribe(url, payload).catch(err => {
      SUB_MAP.delete(routingKey);
      console.error(`failed to subscribe to ${url}`, err);
      setError(err);
    });

    return () => {
      // if (!SUB_MAP.has(routingKey)) {
      //   //we're not subscribed to this, don't unsubscribe
      //   console.warn(
      //     'trying to unsubscribe from a routing key we are not subscribed to',
      //     routingKey
      //   );
      //   return;
      // }
      // SUB_MAP.delete(routingKey);
      // unsubscribe(url, payload).catch(err => {
      //   console.error(`failed to unsubscribe from ${url}`, err);
      // });
    };
    //eslint-disable-next-line
  }, [routingKey]);

  const clearError = () => setError(null);

  return [error, clearError];
};

export default useSubscribeTo;
