import { useEffect } from 'react';
import invariant from 'invariant';

import { track } from 'scripts/analytics';

const useTrack = (category, label, data = {}, waitForLabel = false) => {
  invariant(category, `useTrack requires at LEAST a "category" to be passed but got: ${category}`);

  useEffect(() => {
    if (waitForLabel && !label) {
      return;
    }
    track(category, 'mount', label, data);

    return () => {
      if (waitForLabel && !label) {
        return;
      }
      track(category, 'unmount', label, data);
    };
    //eslint-disable-next-line
  }, [category, label]);

  return (action, additionalData = {}) => {
    invariant(action, `tracking requires you to pass "action" first but got: ${action}`);

    track(category, action, label || additionalData.label, { ...data, ...additionalData });
  };
};

export default useTrack;
