import { subscribeKey, updateKey } from 'controllers/user-settings';
import useObservable from './useObservable';

const useUserSettings = key => {
  const key$ = subscribeKey(key);
  const value = useObservable(key$);

  const setValue = value => {
    return updateKey(key, value);
  };

  return [value, setValue];
};

export default useUserSettings;
