import 'classes/Logs';
import 'resize-observer-polyfill';

import './styles/bebo-style/_reset.scss';
import './styles/root.scss';

import React from 'react';
import { unstable_createRoot } from 'react-dom';

import config from 'scripts/config';

import UserController from 'controllers/user';
import App from './app';
import { getBeboAppVersion } from 'scripts/utils';

import TitleBar from 'components/title-bar';
import UpgradeError from 'components/upgrade-error';

//rest of aplication after

try {
  window.__timeStamp('init_js');
} catch (err) {
  console.error('failed to __timeStamp init_js time', err);
}

const MIN_VALID_APP_VERSION = { major: 999, minor: 0, patch: 0 };

const isAppVersionValid = () => {
  return new Promise((resolve, reject) => {
    const version = getBeboAppVersion();
    if (version === null) {
      //web, continue
      return resolve();
    }

    if (
      version.major >= MIN_VALID_APP_VERSION.major &&
      version.minor >= MIN_VALID_APP_VERSION.minor &&
      version.patch >= MIN_VALID_APP_VERSION.patch
    ) {
      return resolve();
    }
    return reject();
  });
};

const runUI = () => {
  return isAppVersionValid()
    .then(() => {
      unstable_createRoot(document.getElementById('app')).render(<App />);
    })
    .catch(() => {
      console.error('failed bebo-app version check, showing update UI');
      unstable_createRoot(document.getElementById('app')).render(<ForceAppUpdate />);
    });
};

const ForceAppUpdate = () => {
  return (
    <div>
      <TitleBar />
      <UpgradeError />
    </div>
  );
};

runUI();

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: http://bit.ly/CRA-PWA
// serviceWorker.unregister();
