import React, { memo, useEffect, useState } from 'react';

import { Router, Redirect } from '@reach/router';

import { GET } from 'classes/socket';

//sub-pages
import League from './pages/league';

//end sub-pages

import useActingUser from 'hooks/useActingUser';

import Navigation from 'components/navigation';
import OffCanvas from 'components/off-canvas';
import { NavBarRenderer } from 'components/nav-bar';
import View from 'components/view';

const MatchRedirect = memo(() => {
  const [match, setMatch] = useState(null);
  const [matchError, setMatchError] = useState(null);
  const actingUser = useActingUser();
  const { active_match_id } = actingUser;

  useEffect(() => {
    setMatch(null);
    setMatchError(null);
    if (active_match_id) {
      GET('/match', { match_id: active_match_id })
        .then(response => {
          const match = response && response.result && response.result[0];
          if (!match) {
            return Promise.reject(new Error('no match in result[0]'));
          }
          setMatch(match);
        })
        .catch(err => {
          console.error('failed to get match', err);
          setMatchError(err);
        });
    }
  }, [active_match_id]);

  if (!matchError && match && match.match_id && match.league_id) {
    return (
      <Redirect
        noThrow
        key={match.match_id}
        to={`/app/league/${match.league_id}/match/${match.match_id}`}
      />
    );
  }

  return null;
});

let last = 0;

function AppPage(props) {
  const [viewScrollTop, setViewScrollTop] = useState('up');

  const onScroll = e => {
    const { scrollTop, scrollHeight, clientHeight } = e.target;
    const direction = scrollTop > last ? 'down' : 'up';

    if (
      !(last < 0) &&
      !(scrollHeight - scrollTop - clientHeight <= 0) &&
      direction !== viewScrollTop
    ) {
      setViewScrollTop(direction);
    }
    last = scrollTop;
  };

  return (
    <>
      <MatchRedirect />
      <div
        style={{
          display: 'flex',
          flexDirection: 'row',
          position: 'absolute',
          top: 0,
          left: 0,
          right: 0,
          bottom: 0
        }}
      >
        <Navigation left={<OffCanvas />}>
          <View onScroll={onScroll} nav={<NavBarRenderer viewScrollTop={viewScrollTop} />}>
            <Router style={{ width: '100%', height: '100%' }}>
              <League path="league/:league_id/*" />
            </Router>
          </View>
        </Navigation>
      </div>
    </>
  );
}

export default memo(AppPage);
