import React from 'react';
import useSocketSubscription from 'hooks/useSocketSubscription';

import NavBar from 'components/nav-bar';

import Team from 'components/team';

function TeamPage({ league_id, team, actingUser, standings }) {
  const [matchInfo] = useSocketSubscription('/match/team', { team_id: team && team.team_id }, [], {
    reFetch: true
  });

  let [matchHistory] = useSocketSubscription('/match', { team_id: team && team.team_id }, [], {
    reFetch: true,
    initOptions: { tournament_id: 'null' }
  });

  if (!matchHistory || !matchHistory.length) {
    matchHistory = matchInfo.sort((a, b) => new Date(b.created_dttm) - new Date(a.created_dttm));
  }

  // console.log('teamPAge **', matchInfo);

  const isOwner = actingUser && team && team.owner_id && team.owner_id === actingUser.user_id;

  const props = {
    actingUser,
    team,
    standings,
    matchHistory,
    matchInfo,
    league_id,
    isOwner
  };

  return (
    <>
      <NavBar description="My Team" />
      <Team {...props} />
    </>
  );
}

export default TeamPage;
