import React, { memo } from 'react';

import { Column, Row, Button } from 'bebo-ui';

import { useMedia } from 'the-platform';

import config from 'scripts/config';

import css from './download.module.scss';

import useTrack from 'hooks/useTrack';
import useLoadTimes from 'hooks/useLoadTimes';

import Header from 'components/header';
import Footer from 'components/footer';

export default memo(function Download() {
  useLoadTimes();
  const noMobile = useMedia({ minWidth: 1024 }, window.innerWidth > 1024);

  return (
    <Column className={css.container}>
      <Header background="#000" inverse />
      <DownloadContent mobile={!noMobile} />
      <Footer inverse />
    </Column>
  );
});

const DownloadContent = memo(({ mobile }) => {
  const track = useTrack('download', '', { mobile });
  return (
    <Column className={css.content} grow={100}>
      <Row className={css.wrapper}>
        <Column className={css.hero}>
          <h3>Get Bebo for Windows</h3>
          <p>The Bebo Windows app is currently required for automagic tracking of scores.</p>

          <Button
            className={css.button}
            onClick={() => track('click')}
            link={config.APP_DL_URL}
            external
            download
            primary
          >
            Download Now
          </Button>
          <span>Available for Windows 10</span>
        </Column>
      </Row>
    </Column>
  );
});
