import React, { useState, useMemo, memo } from 'react';
import { Redirect } from '@reach/router';

import { getUserStorage, isDesktopApp } from 'scripts/utils';

import useActingUser from 'hooks/useActingUser';
import useTrack from 'hooks/useTrack';
import useLoadTimes from 'hooks/useLoadTimes';

import useUserSettings from 'hooks/useUserSettings';

import FtuxContainer from 'components/ftux';

//there should be no need to touch anything above this

//@derek / @viktor you should import pages from './pages folder here

import FtuxStep0 from 'components/ftux/steps/ftux-step0';
import FtuxStep1 from 'components/ftux/steps/ftux-step1';
import FtuxStep2 from 'components/ftux/steps/ftux-step2';
// import FtuxStep3 from 'components/ftux/steps/ftux-step3';
// import FtuxStep4 from 'components/ftux/steps/ftux-step4';
import FtuxStep5 from 'components/ftux/steps/ftux-step5';
//import FtuxStep6 from 'components/ftux/steps/ftux-step6';
import Platform from 'components/ftux/steps/platform';

//@derek / @viktor then add the pages into pages array like so: (pages will be displayed in order)
const PAGES = [
  {
    id: 'ftux0',
    title: 'Choose a username',
    subtitle: 'You can change this later',
    Component: FtuxStep0,
    noButton: true
  },
  { id: 'ftux1', title: 'Season Zero', Component: FtuxStep1 },
  { id: 'ftux2', title: 'How does a match work?', Component: FtuxStep2 },
  // {
  //   id: 'ftux3',
  //   title: 'Rankings',
  //   subtitle: 'League standings update live on Bebo.com',
  //   Component: FtuxStep3,
  //   notInWeb: true
  // },
  // { id: 'ftux4', title: 'Rules & Reqs.', Component: FtuxStep4, notInWeb: true },
  {
    id: 'ftux5',
    title: 'Need Help?',
    subtitle: 'Use the #help channel in Discord and our team will assist you.',
    Component: FtuxStep5
  },

  {
    id: 'platform',
    title: 'Choose a platform',
    Component: Platform,
    noButton: true,
    notInApp: true
  }
  //{
  //id: 'ftux6',
  //title: 'You got Bebo first',
  //subtitle: 'Alpha. Beta. Early Access. Pre-Launch. Not perfect. Brand spanking new.',
  //buttonText: 'Done',
  //Component: FtuxStep6
  //}
];

//there should be no need to touch anything below here

let newSeenPages = [];

const LEAGUES_WITH_HS_DISCORD = ['b60bb61b-7ccd-4896-9e39-53c4e7b6b6b2'];

export default memo(function FTUX() {
  useLoadTimes();
  useTrack('signup_funnel', 'ftux');
  const [previousLeagueId] = useUserSettings('last-league');

  const actingUser = useActingUser();
  const [pageId, setPageId] = useState(0);
  const seenPages = useMemo(() => {
    newSeenPages = getUserStorage(actingUser && actingUser.user_id).get(`ftux`) || [];
    return newSeenPages;
  }, [actingUser]);

  const filterPages = PAGES.filter(
    p =>
      ((!p.notInApp || !isDesktopApp()) && (!p.notInWeb || isDesktopApp())) ||
      (actingUser &&
        actingUser.campaign &&
        actingUser.campaign.league_id &&
        LEAGUES_WITH_HS_DISCORD.indexOf(actingUser.campaign.league_id) > -1)
  );

  const showPages = filterPages.filter(p => seenPages.indexOf(p.id) === -1);

  const leagueId = useMemo(() => {
    let lId = previousLeagueId || '';
    const leagues = (actingUser && actingUser.leagues) || [];

    if (leagues.length && !lId) {
      lId = leagues[0] && leagues[0].league_id;
    }

    return lId;
  }, [actingUser, previousLeagueId]);

  if (pageId >= showPages.length) {
    if (leagueId) {
      return <Redirect noThrow to={`/app/league/${leagueId}`} />;
    }

    return <Redirect noThrow to={`/success`} />;
  }

  const nextFn = () => {
    newSeenPages = [...new Set([...newSeenPages, showPages[pageId].id])];
    getUserStorage(actingUser.user_id).set('ftux', newSeenPages);
    setPageId(pageId + 1);
  };

  const onBackFn = () => {
    if (pageId !== 0) {
      setPageId(pageId - 1);
    }
  };

  return <FtuxContainer {...showPages[pageId]} onNext={nextFn} onBack={onBackFn} />;
});
